<?php

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

  Script: Maian Gallery v2.0
  Written by: David Ian Bennett
  E-Mail: support@maianscriptworld.co.uk
  Website: http://www.maianscriptworld.co.uk

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  
  This File: class_paypal.inc.php
  Description: Paypal Process Class
  Written by: David Ian Bennett

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

class paypalIPN extends genericOptions {
        
var $paypal_post_vars;
var $paypal_response;
var $url_string;
var $timeout;
var $error_log_file = 'log/paypal_errors.txt';
var $fields         = array();

// Class Constructor..
function paypalIPN($paypal_post_vars,$settings)
{
  $this->paypal_post_vars  = $paypal_post_vars;
	$this->timeout           = 120;
	$this->log               = $settings->ppLog;
	$this->url_string        = "http".($settings->ppSSL ? 's' : '').($settings->ppSandbox ? '://www.sandbox.paypal.com/cgi-bin/webscr?' : '://www.paypal.com/cgi-bin/webscr?');
}

// Send data back to Paypal..
function send_response()
{
  foreach($this->paypal_post_vars AS $key => $value) {
    $values[] = $key.'='.urlencode($this->strip_slashes($value));
  }
    
  $this->url_string .= @implode("&", $values);
  $this->url_string .= "&cmd=_notify-validate";

  $ch = curl_init();
  curl_setopt ($ch, CURLOPT_URL, $this->url_string);
  curl_setopt ($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; www.maianscriptworld.co.uk; Maian Gallery)");
  curl_setopt ($ch, CURLOPT_HEADER, 1);
  curl_setopt ($ch, CURLOPT_RETURNTRANSFER, 1);
  
  // Prevent basedir & safe mode errors..
  if (ini_get('open_basedir') == '' && ini_get('safe_mode' == 'Off')) {
  curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
  }
  
  curl_setopt ($ch, CURLOPT_TIMEOUT, $this->timeout);
  $this->paypal_response = curl_exec ($ch);
  curl_close($ch);
}

// Was payment verified..
function is_verified()
{
  if (strpos($this->paypal_response,'VERIFIED')===FALSE) {
    return false;
  } else {
    return true;
  }
}

// Returns payment status..
function get_payment_status()
{
  return $this->paypal_post_vars['payment_status'];
}
                  
// Logs error messages..
function error_out($msg)
{
  $date     = date("D M j G:i:s T Y", time());
  $message  = '';
     
  $message .= $this->define_newline().$this->define_newline().$msg.$this->define_newline().$this->define_newline();

  reset($this->paypal_post_vars);

  while(list($key,$value) = each($this->paypal_post_vars) ) {
    $message .= $key.':'." \t".$value.$this->define_newline();
  }

	$message .= $this->define_newline().$this->define_newline().$this->url_string.$this->define_newline().$this->define_newline().$this->paypal_response.$this->define_newline().$this->define_newline();

  if($this->log) {
    $fp = fopen($this->error_log_file, 'ab');
    fwrite($fp, trim($message));
    fclose($fp);
  }
}

// Assigns field array..
function add_field($field,$value)
{
  $this->fields[$field] = $value;
}
                  
// Loads processing screen..
function loadHiddenFields()
{
  $html = '<form method="post" name="form" action="'.$this->url_string.'">';
  
  foreach ($this->fields AS $name => $value) { 
    $html .= '<input type="hidden" name="'.$name.'" value="'.$this->strip_slashes($value).'">'."\n";
  }
  
  $html .= '</form>';

  return $html;
}

}

?>
